/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.util.CarFlagEncoder;
import com.graphhopper.util.PMap;
import java.util.Set;

public class Car4WDFlagEncoder
extends CarFlagEncoder {
    public Car4WDFlagEncoder() {
        this(5, 5.0, 0);
    }

    public Car4WDFlagEncoder(PMap properties) {
        super(properties);
    }

    public Car4WDFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    public Car4WDFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        super(speedBits, speedFactor, maxTurnCosts);
        this.init();
        this.trackTypeSpeedMap.put("grade4", 5);
        this.trackTypeSpeedMap.put("grade5", 5);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public long acceptWay(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Set<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return 0L;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return this.acceptBit | this.ferryBit;
                }
            }
            return 0L;
        }
        if (!this.defaultSpeedMap.containsKey(highwayValue)) {
            return 0L;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return 0L;
        }
        if (!firstValue.isEmpty()) {
            if (this.restrictedValues.contains(firstValue) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                return 0L;
            }
            if (this.intendedValues.contains(firstValue)) {
                return this.acceptBit;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return 0L;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return 0L;
        }
        return this.acceptBit;
    }

    @Override
    public String toString() {
        return "car4wd";
    }
}

