/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ConditionalTagInspector;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalOSMTagInspector;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.util.EncodedDoubleValue;
import com.graphhopper.routing.util.EncodedValue;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TurnCostEncoder;
import com.graphhopper.routing.weighting.TurnWeighting;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.PMap;
import com.graphhopper.util.Translation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFlagEncoder
implements FlagEncoder,
TurnCostEncoder {
    protected static final int K_FORWARD = 0;
    protected static final int K_BACKWARD = 1;
    private static final Logger logger = LoggerFactory.getLogger(AbstractFlagEncoder.class);
    protected final List<String> restrictions = new ArrayList<String>(5);
    protected final Set<String> intendedValues = new HashSet<String>(5);
    protected final Set<String> restrictedValues = new HashSet<String>(5);
    protected final Set<String> ferries = new HashSet<String>(5);
    protected final Set<String> oneways = new HashSet<String>(5);
    protected final Set<String> absoluteBarriers = new HashSet<String>(5);
    protected final Set<String> potentialBarriers = new HashSet<String>(5);
    protected final int speedBits;
    protected final double speedFactor;
    private final int maxTurnCosts;
    protected long forwardBit;
    protected long backwardBit;
    protected long directionBitMask;
    protected long roundaboutBit;
    protected EncodedDoubleValue speedEncoder;
    protected long acceptBit;
    protected long ferryBit;
    protected PMap properties;
    protected int maxPossibleSpeed;
    protected EdgeExplorer edgeOutExplorer;
    protected EdgeExplorer edgeInExplorer;
    private long nodeBitMask;
    private long wayBitMask;
    private long relBitMask;
    private EncodedValue turnCostEncoder;
    private long turnRestrictionBit;
    private boolean blockByDefault = true;
    private boolean blockFords = true;
    private boolean registered;
    protected static final double UNKNOWN_DURATION_FERRY_SPEED = 5.0;
    protected static final double SHORT_TRIP_FERRY_SPEED = 20.0;
    protected static final double LONG_TRIP_FERRY_SPEED = 30.0;
    private ConditionalTagInspector conditionalTagInspector;

    public AbstractFlagEncoder(PMap properties) {
        throw new RuntimeException("This method must be overridden in derived classes");
    }

    public AbstractFlagEncoder(String propertiesStr) {
        this(new PMap(propertiesStr));
    }

    protected AbstractFlagEncoder(int speedBits, double speedFactor, int maxTurnCosts) {
        this.maxTurnCosts = maxTurnCosts <= 0 ? 0 : maxTurnCosts;
        this.speedBits = speedBits;
        this.speedFactor = speedFactor;
        this.oneways.add("yes");
        this.oneways.add("true");
        this.oneways.add("1");
        this.oneways.add("-1");
        this.ferries.add("shuttle_train");
        this.ferries.add("ferry");
    }

    protected void init() {
        this.conditionalTagInspector = new ConditionalOSMTagInspector(DateRangeParser.createCalendar(), this.restrictions, this.restrictedValues, this.intendedValues);
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public void setBlockByDefault(boolean blockByDefault) {
        this.blockByDefault = blockByDefault;
    }

    public boolean isBlockFords() {
        return this.blockFords;
    }

    public void setBlockFords(boolean blockFords) {
        this.blockFords = blockFords;
    }

    public ConditionalTagInspector getConditionalTagInspector() {
        return this.conditionalTagInspector;
    }

    protected void setConditionalTagInspector(ConditionalTagInspector conditionalTagInspector) {
        this.conditionalTagInspector = conditionalTagInspector;
    }

    public int defineNodeBits(int index, int shift) {
        return shift;
    }

    public int defineWayBits(int index, int shift) {
        this.forwardBit = 1L << shift;
        this.backwardBit = 2L << shift;
        this.directionBitMask = 3L << shift;
        this.roundaboutBit = 1L << (shift += 2);
        this.acceptBit = 1L << (index *= 2);
        this.ferryBit = 2L << index;
        return ++shift;
    }

    public int defineRelationBits(int index, int shift) {
        return shift;
    }

    public abstract long handleRelationTags(ReaderRelation var1, long var2);

    public abstract long acceptWay(ReaderWay var1);

    public abstract long handleWayTags(ReaderWay var1, long var2, long var4);

    public long handleNodeTags(ReaderNode node) {
        if (node.hasTag("barrier", this.absoluteBarriers)) {
            return this.directionBitMask;
        }
        if (node.hasTag("barrier", this.potentialBarriers)) {
            boolean locked = false;
            if (node.hasTag("locked", (Object)"yes")) {
                locked = true;
            }
            for (String res : this.restrictions) {
                if (!locked && node.hasTag(res, this.intendedValues)) {
                    return 0L;
                }
                if (!node.hasTag(res, this.restrictedValues)) continue;
                return this.directionBitMask;
            }
            if (this.blockByDefault) {
                return this.directionBitMask;
            }
        }
        if (this.blockFords && (node.hasTag("highway", (Object)"ford") || node.hasTag("ford", new String[0])) && !node.hasTag(this.restrictions, this.intendedValues) && !node.hasTag("ford", (Object)"no")) {
            return this.directionBitMask;
        }
        return 0L;
    }

    @Override
    public InstructionAnnotation getAnnotation(long flags, Translation tr) {
        return InstructionAnnotation.EMPTY;
    }

    public long reverseFlags(long flags) {
        long dir = flags & this.directionBitMask;
        if (dir == this.directionBitMask || dir == 0L) {
            return flags;
        }
        return flags ^ this.directionBitMask;
    }

    public long flagsDefault(boolean forward, boolean backward) {
        long flags = this.speedEncoder.setDefaultValue(0L);
        return this.setAccess(flags, forward, backward);
    }

    @Override
    public long setAccess(long flags, boolean forward, boolean backward) {
        return this.setBool(this.setBool(flags, 1, backward), 0, forward);
    }

    @Override
    public long setSpeed(long flags, double speed) {
        if (speed < 0.0 || Double.isNaN(speed)) {
            throw new IllegalArgumentException("Speed cannot be negative or NaN: " + speed + ", flags:" + BitUtil.LITTLE.toBitString(flags));
        }
        if (speed < this.speedEncoder.factor / 2.0) {
            return this.setLowSpeed(flags, speed, false);
        }
        if (speed > this.getMaxSpeed()) {
            speed = this.getMaxSpeed();
        }
        return this.speedEncoder.setDoubleValue(flags, speed);
    }

    protected long setLowSpeed(long flags, double speed, boolean reverse) {
        return this.setAccess(this.speedEncoder.setDoubleValue(flags, 0.0), false, false);
    }

    @Override
    public double getSpeed(long flags) {
        double speedVal = this.speedEncoder.getDoubleValue(flags);
        if (speedVal < 0.0) {
            throw new IllegalStateException("Speed was negative!? " + speedVal);
        }
        return speedVal;
    }

    @Override
    public long setReverseSpeed(long flags, double speed) {
        return this.setSpeed(flags, speed);
    }

    @Override
    public double getReverseSpeed(long flags) {
        return this.getSpeed(flags);
    }

    @Override
    public long setProperties(double speed, boolean forward, boolean backward) {
        return this.setAccess(this.setSpeed(0L, speed), forward, backward);
    }

    @Override
    public double getMaxSpeed() {
        return this.speedEncoder.getMaxValue();
    }

    protected double getMaxSpeed(ReaderWay way) {
        double backSpeed;
        double maxSpeed = this.parseSpeed(way.getTag("maxspeed"));
        double fwdSpeed = this.parseSpeed(way.getTag("maxspeed:forward"));
        if (fwdSpeed >= 0.0 && (maxSpeed < 0.0 || fwdSpeed < maxSpeed)) {
            maxSpeed = fwdSpeed;
        }
        if ((backSpeed = this.parseSpeed(way.getTag("maxspeed:backward"))) >= 0.0 && (maxSpeed < 0.0 || backSpeed < maxSpeed)) {
            maxSpeed = backSpeed;
        }
        return maxSpeed;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (int)this.directionBitMask;
        hash = 61 * hash + this.toString().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        AbstractFlagEncoder other = (AbstractFlagEncoder)obj;
        if (this.directionBitMask != other.directionBitMask) {
            return false;
        }
        return this.toString().equals(other.toString());
    }

    protected double parseSpeed(String str) {
        if (Helper.isEmpty(str)) {
            return -1.0;
        }
        if ("none".equals(str)) {
            return 140.0;
        }
        if (str.endsWith(":rural") || str.endsWith(":trunk")) {
            return 80.0;
        }
        if (str.endsWith(":urban")) {
            return 50.0;
        }
        if (str.equals("walk") || str.endsWith(":living_street")) {
            return 6.0;
        }
        try {
            int mpInteger = str.indexOf("mp");
            if (mpInteger > 0) {
                str = str.substring(0, mpInteger).trim();
                int val = Integer.parseInt(str);
                return (double)val * 1.609344;
            }
            int knotInteger = str.indexOf("knots");
            if (knotInteger > 0) {
                str = str.substring(0, knotInteger).trim();
                int val = Integer.parseInt(str);
                return (double)val * 1.852;
            }
            int kmInteger = str.indexOf("km");
            if (kmInteger > 0) {
                str = str.substring(0, kmInteger).trim();
            } else {
                kmInteger = str.indexOf("kph");
                if (kmInteger > 0) {
                    str = str.substring(0, kmInteger).trim();
                }
            }
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return -1.0;
        }
    }

    public void applyWayTags(ReaderWay way, EdgeIteratorState edge) {
    }

    protected double getFerrySpeed(ReaderWay way) {
        long duration = 0L;
        try {
            duration = Long.parseLong(way.getTag("duration:seconds"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        double durationInHours = (double)duration / 60.0 / 60.0;
        Number estimatedLength = way.getTag("estimated_distance", null);
        if (durationInHours > 0.0) {
            try {
                if (estimatedLength != null) {
                    long firstId;
                    double estimatedLengthInKm = estimatedLength.doubleValue() / 1000.0;
                    double calculatedTripSpeed = estimatedLengthInKm / durationInHours / 1.4;
                    if (calculatedTripSpeed > 0.01) {
                        if (calculatedTripSpeed > this.getMaxSpeed()) {
                            return this.getMaxSpeed();
                        }
                        if ((double)Math.round(calculatedTripSpeed) < this.speedEncoder.factor / 2.0) {
                            return this.speedEncoder.factor / 2.0;
                        }
                        return Math.round(calculatedTripSpeed);
                    }
                    long lastId = way.getNodes().isEmpty() ? -1L : way.getNodes().get(way.getNodes().size() - 1);
                    long l = firstId = way.getNodes().isEmpty() ? -1L : way.getNodes().get(0);
                    if (firstId != lastId) {
                        logger.warn("Unrealistic long duration ignored in way with way ID=" + way.getId() + " : Duration tag value=" + way.getTag("duration") + " (=" + Math.round((double)duration / 60.0) + " minutes)");
                    }
                    durationInHours = 0.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (durationInHours == 0.0) {
            if (estimatedLength != null && estimatedLength.doubleValue() <= 300.0) {
                return this.speedEncoder.factor / 2.0;
            }
            return 5.0;
        }
        if (durationInHours > 1.0) {
            return 30.0;
        }
        return 20.0;
    }

    void setWayBitMask(int usedBits, int shift) {
        this.wayBitMask = (1L << usedBits) - 1L;
        this.wayBitMask <<= shift;
    }

    long getWayBitMask() {
        return this.wayBitMask;
    }

    void setRelBitMask(int usedBits, int shift) {
        this.relBitMask = (1L << usedBits) - 1L;
        this.relBitMask <<= shift;
    }

    long getRelBitMask() {
        return this.relBitMask;
    }

    void setNodeBitMask(int usedBits, int shift) {
        this.nodeBitMask = (1L << usedBits) - 1L;
        this.nodeBitMask <<= shift;
    }

    long getNodeBitMask() {
        return this.nodeBitMask;
    }

    public int defineTurnBits(int index, int shift) {
        if (this.maxTurnCosts == 0) {
            return shift;
        }
        if (this.maxTurnCosts == 1) {
            this.turnRestrictionBit = 1L << shift;
            return shift + 1;
        }
        int turnBits = Helper.countBitValue(this.maxTurnCosts);
        this.turnCostEncoder = new EncodedValue("TurnCost", shift, turnBits, 1.0, 0L, this.maxTurnCosts){

            @Override
            public final long getValue(long flags) {
                flags &= this.mask;
                return flags >>>= (int)this.shift;
            }
        };
        return shift + turnBits;
    }

    @Override
    public boolean isTurnRestricted(long flags) {
        if (this.maxTurnCosts == 0) {
            return false;
        }
        if (this.maxTurnCosts == 1) {
            return (flags & this.turnRestrictionBit) != 0L;
        }
        return this.turnCostEncoder.getValue(flags) == (long)this.maxTurnCosts;
    }

    @Override
    public double getTurnCost(long flags) {
        if (this.maxTurnCosts == 0) {
            return 0.0;
        }
        if (this.maxTurnCosts == 1) {
            return (flags & this.turnRestrictionBit) == 0L ? 0.0 : Double.POSITIVE_INFINITY;
        }
        long cost = this.turnCostEncoder.getValue(flags);
        if (cost == (long)this.maxTurnCosts) {
            return Double.POSITIVE_INFINITY;
        }
        return cost;
    }

    @Override
    public long getTurnFlags(boolean restricted, double costs) {
        if (this.maxTurnCosts == 0) {
            return 0L;
        }
        if (this.maxTurnCosts == 1) {
            if (costs != 0.0) {
                throw new IllegalArgumentException("Only restrictions are supported");
            }
            return restricted ? this.turnRestrictionBit : 0L;
        }
        if (restricted) {
            if (costs != 0.0 || Double.isInfinite(costs)) {
                throw new IllegalArgumentException("Restricted turn can only have infinite costs (or use 0)");
            }
        } else if (costs >= (double)this.maxTurnCosts) {
            throw new IllegalArgumentException("Cost is too high. Or specifiy restricted == true");
        }
        if (costs < 0.0) {
            throw new IllegalArgumentException("Turn costs cannot be negative");
        }
        if (costs >= (double)this.maxTurnCosts || restricted) {
            costs = this.maxTurnCosts;
        }
        return this.turnCostEncoder.setValue(0L, (int)costs);
    }

    protected boolean isFerry(long internalFlags) {
        return (internalFlags & this.ferryBit) != 0L;
    }

    protected boolean isAccept(long internalFlags) {
        return (internalFlags & this.acceptBit) != 0L;
    }

    @Override
    public boolean isBackward(long flags) {
        return (flags & this.backwardBit) != 0L;
    }

    @Override
    public boolean isForward(long flags) {
        return (flags & this.forwardBit) != 0L;
    }

    @Override
    public long setBool(long flags, int key, boolean value) {
        switch (key) {
            case 0: {
                return value ? flags | this.forwardBit : flags & (this.forwardBit ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case 1: {
                return value ? flags | this.backwardBit : flags & (this.backwardBit ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case 2: {
                return value ? flags | this.roundaboutBit : flags & (this.roundaboutBit ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new IllegalArgumentException("Unknown key " + key + " for boolean value");
    }

    @Override
    public boolean isBool(long flags, int key) {
        switch (key) {
            case 0: {
                return this.isForward(flags);
            }
            case 1: {
                return this.isBackward(flags);
            }
            case 2: {
                return (flags & this.roundaboutBit) != 0L;
            }
        }
        throw new IllegalArgumentException("Unknown key " + key + " for boolean value");
    }

    @Override
    public long setLong(long flags, int key, long value) {
        throw new UnsupportedOperationException("Unknown key " + key + " for long value.");
    }

    @Override
    public long getLong(long flags, int key) {
        throw new UnsupportedOperationException("Unknown key " + key + " for long value.");
    }

    @Override
    public long setDouble(long flags, int key, double value) {
        throw new UnsupportedOperationException("Unknown key " + key + " for double value.");
    }

    @Override
    public double getDouble(long flags, int key) {
        throw new UnsupportedOperationException("Unknown key " + key + " for double value.");
    }

    protected double applyMaxSpeed(ReaderWay way, double speed) {
        double maxSpeed = this.getMaxSpeed(way);
        if (maxSpeed >= 0.0) {
            return maxSpeed * 0.9;
        }
        return speed;
    }

    protected String getPropertiesString() {
        return "speed_factor=" + this.speedFactor + "|speed_bits=" + this.speedBits + "|turn_costs=" + (this.maxTurnCosts > 0);
    }

    @Override
    public boolean supports(Class<?> feature) {
        if (TurnWeighting.class.isAssignableFrom(feature)) {
            return this.maxTurnCosts > 0;
        }
        return false;
    }
}

