/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.IntArrayDeque;
import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class TarjansSCCAlgorithm {
    private final ArrayList<IntArrayList> components = new ArrayList();
    private final GraphHopperStorage graph;
    private final IntArrayDeque nodeStack;
    private final GHBitSet onStack;
    private final GHBitSet ignoreSet;
    private final int[] nodeIndex;
    private final int[] nodeLowLink;
    private final EdgeFilter edgeFilter;
    private int index = 1;

    public TarjansSCCAlgorithm(GraphHopperStorage ghStorage, EdgeFilter edgeFilter, boolean ignoreSingleEntries) {
        this.graph = ghStorage;
        this.nodeStack = new IntArrayDeque();
        this.onStack = new GHBitSetImpl(ghStorage.getNodes());
        this.nodeIndex = new int[ghStorage.getNodes()];
        this.nodeLowLink = new int[ghStorage.getNodes()];
        this.edgeFilter = edgeFilter;
        if (ignoreSingleEntries) {
            EdgeExplorer explorer = ghStorage.createEdgeExplorer(edgeFilter);
            int nodes = ghStorage.getNodes();
            this.ignoreSet = new GHBitSetImpl(ghStorage.getNodes());
            int start = 0;
            while (start < nodes) {
                EdgeIterator iter;
                if (!ghStorage.isNodeRemoved(start) && !(iter = explorer.setBaseNode(start)).next()) {
                    this.ignoreSet.add(start);
                }
                ++start;
            }
        } else {
            this.ignoreSet = new GHBitSetImpl();
        }
    }

    public GHBitSet getIgnoreSet() {
        return this.ignoreSet;
    }

    public List<IntArrayList> findComponents() {
        int nodes = this.graph.getNodes();
        int start = 0;
        while (start < nodes) {
            if (this.nodeIndex[start] == 0 && !this.ignoreSet.contains(start) && !this.graph.isNodeRemoved(start)) {
                this.strongConnect(start);
            }
            ++start;
        }
        return this.components;
    }

    private void strongConnect(int firstNode) {
        Stack<TarjanState> stateStack = new Stack<TarjanState>();
        stateStack.push(TarjanState.startState(firstNode));
        block0: while (!stateStack.empty()) {
            int node;
            EdgeIterator iter;
            TarjanState state = (TarjanState)stateStack.pop();
            int start = state.start;
            if (state.isStart()) {
                this.nodeIndex[start] = this.index;
                this.nodeLowLink[start] = this.index++;
                this.nodeStack.addLast(start);
                this.onStack.add(start);
                iter = this.graph.createEdgeExplorer(this.edgeFilter).setBaseNode(start);
            } else {
                iter = state.iter;
                int prevConnectedId = iter.getAdjNode();
                this.nodeLowLink[start] = Math.min(this.nodeLowLink[start], this.nodeLowLink[prevConnectedId]);
            }
            while (iter.next()) {
                int connectedId = iter.getAdjNode();
                if (this.ignoreSet.contains(start)) continue;
                if (this.nodeIndex[connectedId] == 0) {
                    stateStack.push(TarjanState.resumeState(start, iter));
                    stateStack.push(TarjanState.startState(connectedId));
                    continue block0;
                }
                if (!this.onStack.contains(connectedId)) continue;
                this.nodeLowLink[start] = Math.min(this.nodeLowLink[start], this.nodeIndex[connectedId]);
            }
            if (this.nodeIndex[start] != this.nodeLowLink[start]) continue;
            IntArrayList component = new IntArrayList();
            while ((node = this.nodeStack.removeLast()) != start) {
                component.add(node);
                this.onStack.remove(node);
            }
            component.add(start);
            component.trimToSize();
            this.onStack.remove(start);
            this.components.add(component);
        }
    }

    private static class TarjanState {
        final int start;
        final EdgeIterator iter;

        private TarjanState(int start, EdgeIterator iter) {
            this.start = start;
            this.iter = iter;
        }

        public static TarjanState startState(int start) {
            return new TarjanState(start, null);
        }

        public static TarjanState resumeState(int start, EdgeIterator iter) {
            return new TarjanState(start, iter);
        }

        boolean isStart() {
            return this.iter == null;
        }
    }
}

