/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.lm;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import com.graphhopper.coll.MapEntry;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.lm.LandmarkSuggestion;
import com.graphhopper.routing.subnetwork.SubnetworkStorage;
import com.graphhopper.routing.subnetwork.TarjansSCCAlgorithm;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.util.spatialrules.SpatialRule;
import com.graphhopper.routing.util.spatialrules.SpatialRuleLookup;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.ShortestWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.storage.Storable;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LandmarkStorage
implements Storable<LandmarkStorage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LandmarkStorage.class);
    private static final int UNSET_SUBNETWORK = -1;
    private static final int UNCLEAR_SUBNETWORK = 0;
    private long LM_ROW_LENGTH;
    private int landmarks;
    private final int FROM_OFFSET;
    private final int TO_OFFSET;
    private final DataAccess landmarkWeightDA;
    private final List<int[]> landmarkIDs;
    private double factor = -1.0;
    private static final double DOUBLE_MLTPL = 1000000.0;
    private final GraphHopperStorage graph;
    private final FlagEncoder encoder;
    private final Weighting weighting;
    private Weighting lmSelectionWeighting;
    private final TraversalMode traversalMode;
    private boolean initialized;
    private int minimumNodes = 500000;
    private final SubnetworkStorage subnetworkStorage;
    private List<LandmarkSuggestion> landmarkSuggestions = Collections.emptyList();
    private SpatialRuleLookup ruleLookup;
    private boolean logDetails = false;
    static final long PRECISION = 65536L;
    private static final int SHORT_INFINITY = 65535;
    private static final int SHORT_MAX = 65534;
    static final Comparator<Map.Entry<Integer, Integer>> SORT_BY_WEIGHT = new Comparator<Map.Entry<Integer, Integer>>(){

        @Override
        public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
            return Integer.compare(o2.getKey(), o1.getKey());
        }
    };

    public LandmarkStorage(GraphHopperStorage graph, Directory dir, final Weighting weighting, int landmarks) {
        this.graph = graph;
        this.minimumNodes = Math.min(graph.getNodes() / 2, 500000);
        this.encoder = weighting.getFlagEncoder();
        this.weighting = weighting;
        this.lmSelectionWeighting = new ShortestWeighting(this.encoder){

            @Override
            public double calcWeight(EdgeIteratorState edge, boolean reverse, int prevOrNextEdgeId) {
                double res = weighting.calcWeight(edge, reverse, prevOrNextEdgeId);
                if (res >= Double.MAX_VALUE) {
                    return Double.POSITIVE_INFINITY;
                }
                return 1.0;
            }

            @Override
            public String toString() {
                return "LM_BFS|" + LandmarkStorage.this.encoder;
            }
        };
        this.traversalMode = TraversalMode.NODE_BASED;
        String name = AbstractWeighting.weightingToFileName(weighting);
        this.landmarkWeightDA = dir.find("landmarks_" + name);
        this.landmarks = landmarks;
        this.LM_ROW_LENGTH = landmarks * 4;
        this.FROM_OFFSET = 0;
        this.TO_OFFSET = 2;
        this.landmarkIDs = new ArrayList<int[]>();
        this.subnetworkStorage = new SubnetworkStorage(dir, "landmarks_" + name);
    }

    public LandmarkStorage setMaximumWeight(double maxWeight) {
        if (maxWeight > 0.0) {
            this.factor = maxWeight / 65536.0;
            if (Double.isInfinite(this.factor) || Double.isNaN(this.factor)) {
                throw new IllegalStateException("Illegal factor " + this.factor + " calculated from maximum weight " + maxWeight);
            }
        }
        return this;
    }

    public void setLogDetails(boolean logDetails) {
        this.logDetails = logDetails;
    }

    public LandmarkStorage setLandmarkSuggestions(List<LandmarkSuggestion> landmarkSuggestions) {
        if (landmarkSuggestions == null) {
            throw new IllegalArgumentException("landmark suggestions cannot be null");
        }
        this.landmarkSuggestions = landmarkSuggestions;
        return this;
    }

    public void setMinimumNodes(int minimumNodes) {
        this.minimumNodes = minimumNodes;
    }

    public int getMinimumNodes() {
        return this.minimumNodes;
    }

    SubnetworkStorage getSubnetworkStorage() {
        return this.subnetworkStorage;
    }

    public void setLMSelectionWeighting(Weighting lmSelectionWeighting) {
        this.lmSelectionWeighting = lmSelectionWeighting;
    }

    public Weighting getLmSelectionWeighting() {
        return this.lmSelectionWeighting;
    }

    public Weighting getWeighting() {
        return this.weighting;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    public void createLandmarks() {
        StopWatch sw;
        if (this.isInitialized()) {
            throw new IllegalStateException("Initialize the landmark storage only once!");
        }
        long maxBytes = (long)this.graph.getNodes() * this.LM_ROW_LENGTH;
        this.landmarkWeightDA.create(2000L);
        this.landmarkWeightDA.ensureCapacity(maxBytes);
        long pointer = 0L;
        while (pointer < maxBytes) {
            this.landmarkWeightDA.setShort(pointer, (short)-1);
            pointer += 2L;
        }
        String additionalInfo = "";
        if (this.factor <= 0.0) {
            BBox bounds = this.graph.getBounds();
            double distanceInMeter = Helper.DIST_EARTH.calcDist(bounds.maxLat, bounds.maxLon, bounds.minLat, bounds.minLon) * 7.0;
            if (distanceInMeter > 350000.0 || !bounds.isValid()) {
                distanceInMeter = 3.0E7;
            }
            double maxWeight = this.weighting.getMinWeight(distanceInMeter);
            this.setMaximumWeight(maxWeight);
            additionalInfo = ", maxWeight:" + maxWeight + ", from max distance:" + distanceInMeter / 1000.0 + "km";
        }
        if (this.logDetails) {
            LOGGER.info("init landmarks for subnetworks with node count greater than " + this.minimumNodes + " with factor:" + this.factor + additionalInfo);
        }
        int[] empty = new int[this.landmarks];
        Arrays.fill(empty, -1);
        this.landmarkIDs.add(empty);
        byte[] subnetworks = new byte[this.graph.getNodes()];
        Arrays.fill(subnetworks, (byte)-1);
        EdgeFilter tarjanFilter = new DefaultEdgeFilter(this.encoder, false, true);
        IntHashSet blockedEdges = new IntHashSet();
        if (this.ruleLookup != null && this.ruleLookup.size() > 0) {
            sw = new StopWatch().start();
            blockedEdges = this.findBorderEdgeIds(this.ruleLookup);
            tarjanFilter = new BlockedEdgesFilter(this.encoder, false, true, blockedEdges);
            if (this.logDetails) {
                LOGGER.info("Made " + blockedEdges.size() + " edges inaccessible. Calculated country cut in " + sw.stop().getSeconds() + "s, " + Helper.getMemInfo());
            }
        }
        sw = new StopWatch().start();
        TarjansSCCAlgorithm tarjanAlgo = new TarjansSCCAlgorithm(this.graph, tarjanFilter, true);
        List<IntArrayList> graphComponents = tarjanAlgo.findComponents();
        if (this.logDetails) {
            LOGGER.info("Calculated " + graphComponents.size() + " subnetworks via tarjan in " + sw.stop().getSeconds() + "s, " + Helper.getMemInfo());
        }
        EdgeExplorer tmpExplorer = this.graph.createEdgeExplorer(new RequireBothDirectionsEdgeFilter(this.encoder));
        int nodes = 0;
        for (IntArrayList subnetworkIds : graphComponents) {
            nodes += subnetworkIds.size();
            if (subnetworkIds.size() < this.minimumNodes) continue;
            int index = subnetworkIds.size() - 1;
            while (index >= 0) {
                int nextStartNode = subnetworkIds.get(index);
                if (subnetworks[nextStartNode] == -1 && GHUtility.count(tmpExplorer.setBaseNode(nextStartNode)) > 0) {
                    GHPoint p = LandmarkStorage.createPoint(this.graph, nextStartNode);
                    if (this.logDetails) {
                        LOGGER.info("start node: " + nextStartNode + " (" + p + ") subnetwork size: " + subnetworkIds.size() + ", " + Helper.getMemInfo() + (this.ruleLookup == null ? "" : " area:" + this.ruleLookup.lookupRule(p).getId()));
                    }
                    if (this.createLandmarksForSubnetwork(nextStartNode, subnetworks, blockedEdges)) break;
                }
                --index;
            }
            if (index >= 0) continue;
            LOGGER.warn("next start node not found in big enough network of size " + subnetworkIds.size() + ", first element is " + subnetworkIds.get(0) + ", " + LandmarkStorage.createPoint(this.graph, subnetworkIds.get(0)));
        }
        int subnetworkCount = this.landmarkIDs.size();
        this.landmarkWeightDA.ensureCapacity(maxBytes + (long)(subnetworkCount * this.landmarks));
        long bytePos = maxBytes;
        Iterator<int[]> iterator = this.landmarkIDs.iterator();
        while (iterator.hasNext()) {
            int[] landmarks;
            int[] nArray = landmarks = iterator.next();
            int n = landmarks.length;
            int n2 = 0;
            while (n2 < n) {
                int lmNodeId = nArray[n2];
                this.landmarkWeightDA.setInt(bytePos, lmNodeId);
                bytePos += 4L;
                ++n2;
            }
        }
        this.landmarkWeightDA.setHeader(0, this.graph.getNodes());
        this.landmarkWeightDA.setHeader(4, this.landmarks);
        this.landmarkWeightDA.setHeader(8, subnetworkCount);
        if (this.factor * 1000000.0 > 2.147483647E9) {
            throw new UnsupportedOperationException("landmark weight factor cannot be bigger than Integer.MAX_VALUE " + this.factor * 1000000.0);
        }
        this.landmarkWeightDA.setHeader(12, (int)Math.round(this.factor * 1000000.0));
        this.subnetworkStorage.create(this.graph.getNodes());
        int nodeId = 0;
        while (nodeId < subnetworks.length) {
            this.subnetworkStorage.setSubnetwork(nodeId, subnetworks[nodeId]);
            ++nodeId;
        }
        if (this.logDetails) {
            LOGGER.info("Finished landmark creation. Subnetwork node count sum " + nodes + " vs. nodes " + this.graph.getNodes());
        }
        this.initialized = true;
    }

    private boolean createLandmarksForSubnetwork(int startNode, byte[] subnetworks, IntHashSet blockedEdges) {
        int subnetworkId = this.landmarkIDs.size();
        int[] tmpLandmarkNodeIds = new int[this.landmarks];
        int logOffset = Math.max(1, tmpLandmarkNodeIds.length / 2);
        boolean pickedPrecalculatedLandmarks = false;
        if (!this.landmarkSuggestions.isEmpty()) {
            NodeAccess na = this.graph.getNodeAccess();
            double lat = na.getLatitude(startNode);
            double lon = na.getLongitude(startNode);
            LandmarkSuggestion selectedSuggestion = null;
            for (LandmarkSuggestion lmsugg : this.landmarkSuggestions) {
                if (!lmsugg.getBox().contains(lat, lon)) continue;
                selectedSuggestion = lmsugg;
                break;
            }
            if (selectedSuggestion != null) {
                if (selectedSuggestion.getNodeIds().size() < tmpLandmarkNodeIds.length) {
                    throw new IllegalArgumentException("landmark suggestions are too few " + selectedSuggestion.getNodeIds().size() + " for requested landmarks " + this.landmarks);
                }
                pickedPrecalculatedLandmarks = true;
                int i = 0;
                while (i < tmpLandmarkNodeIds.length) {
                    int lmNodeId;
                    tmpLandmarkNodeIds[i] = lmNodeId = selectedSuggestion.getNodeIds().get(i).intValue();
                    ++i;
                }
            }
        }
        if (pickedPrecalculatedLandmarks) {
            LOGGER.info("Picked " + tmpLandmarkNodeIds.length + " landmark suggestions, skipped expensive landmark determination");
        } else {
            Weighting initWeighting = this.lmSelectionWeighting;
            LandmarkExplorer explorer = new LandmarkExplorer(this.graph, this, initWeighting, this.traversalMode);
            explorer.initFrom(startNode, 0.0);
            explorer.setFilter(blockedEdges, true, true);
            explorer.runAlgo(true);
            if (explorer.getFromCount() < this.minimumNodes) {
                explorer.setSubnetworks(subnetworks, 0);
                return false;
            }
            tmpLandmarkNodeIds[0] = explorer.getLastNode();
            int lmIdx = 0;
            while (lmIdx < tmpLandmarkNodeIds.length - 1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException("Thread was interrupted");
                }
                explorer = new LandmarkExplorer(this.graph, this, initWeighting, this.traversalMode);
                explorer.setFilter(blockedEdges, true, true);
                int j = 0;
                while (j < lmIdx + 1) {
                    explorer.initFrom(tmpLandmarkNodeIds[j], 0.0);
                    ++j;
                }
                explorer.runAlgo(true);
                tmpLandmarkNodeIds[lmIdx + 1] = explorer.getLastNode();
                if (this.logDetails && lmIdx % logOffset == 0) {
                    LOGGER.info("Finding landmarks [" + this.weighting + "] in network [" + explorer.getVisitedNodes() + "]. " + "Progress " + (int)(100.0 * (double)lmIdx / (double)tmpLandmarkNodeIds.length) + "%, " + Helper.getMemInfo());
                }
                ++lmIdx;
            }
            if (this.logDetails) {
                LOGGER.info("Finished searching landmarks for subnetwork " + subnetworkId + " of size " + explorer.getVisitedNodes());
            }
        }
        int lmIdx = 0;
        while (lmIdx < tmpLandmarkNodeIds.length) {
            if (Thread.currentThread().isInterrupted()) {
                throw new RuntimeException("Thread was interrupted");
            }
            int lmNodeId = tmpLandmarkNodeIds[lmIdx];
            LandmarkExplorer explorer = new LandmarkExplorer(this.graph, this, this.weighting, this.traversalMode);
            explorer.initFrom(lmNodeId, 0.0);
            explorer.setFilter(blockedEdges, false, true);
            explorer.runAlgo(true);
            explorer.initLandmarkWeights(lmIdx, lmNodeId, this.LM_ROW_LENGTH, this.FROM_OFFSET);
            if (lmIdx == 0 && explorer.setSubnetworks(subnetworks, subnetworkId)) {
                return false;
            }
            explorer = new LandmarkExplorer(this.graph, this, this.weighting, this.traversalMode);
            explorer.initTo(lmNodeId, 0.0);
            explorer.setFilter(blockedEdges, true, false);
            explorer.runAlgo(false);
            explorer.initLandmarkWeights(lmIdx, lmNodeId, this.LM_ROW_LENGTH, this.TO_OFFSET);
            if (lmIdx == 0 && explorer.setSubnetworks(subnetworks, subnetworkId)) {
                return false;
            }
            if (this.logDetails && lmIdx % logOffset == 0) {
                LOGGER.info("Set landmarks weights [" + this.weighting + "]. " + "Progress " + (int)(100.0 * (double)lmIdx / (double)tmpLandmarkNodeIds.length) + "%");
            }
            ++lmIdx;
        }
        this.landmarkIDs.add(tmpLandmarkNodeIds);
        return true;
    }

    public void setSpatialRuleLookup(SpatialRuleLookup ruleLookup) {
        this.ruleLookup = ruleLookup;
    }

    protected IntHashSet findBorderEdgeIds(SpatialRuleLookup ruleLookup) {
        AllEdgesIterator allEdgesIterator = this.graph.getAllEdges();
        NodeAccess nodeAccess = this.graph.getNodeAccess();
        IntHashSet inaccessible = new IntHashSet();
        while (allEdgesIterator.next()) {
            int baseNode;
            SpatialRule ruleBase;
            int adjNode = allEdgesIterator.getAdjNode();
            SpatialRule ruleAdj = ruleLookup.lookupRule(nodeAccess.getLatitude(adjNode), nodeAccess.getLongitude(adjNode));
            if (ruleAdj == (ruleBase = ruleLookup.lookupRule(nodeAccess.getLatitude(baseNode = allEdgesIterator.getBaseNode()), nodeAccess.getLongitude(baseNode)))) continue;
            inaccessible.add(allEdgesIterator.getEdge());
        }
        return inaccessible;
    }

    double getFactor() {
        return this.factor;
    }

    int getFromWeight(int landmarkIndex, int node) {
        int res = this.landmarkWeightDA.getShort((long)node * this.LM_ROW_LENGTH + (long)(landmarkIndex * 4) + (long)this.FROM_OFFSET) & 0xFFFF;
        assert (res >= 0) : "Negative to weight " + res + ", landmark index:" + landmarkIndex + ", node:" + node;
        if (res == 65535) {
            return 65534;
        }
        return res;
    }

    int getToWeight(int landmarkIndex, int node) {
        int res = this.landmarkWeightDA.getShort((long)node * this.LM_ROW_LENGTH + (long)(landmarkIndex * 4) + (long)this.TO_OFFSET) & 0xFFFF;
        assert (res >= 0) : "Negative to weight " + res + ", landmark index:" + landmarkIndex + ", node:" + node;
        if (res == 65535) {
            return 65534;
        }
        return res;
    }

    final boolean setWeight(long pointer, double value) {
        double tmpVal = value / this.factor;
        if (tmpVal > 2.147483647E9) {
            throw new UnsupportedOperationException("Cannot store infinity explicitely, pointer=" + pointer + ", value: " + value);
        }
        if (tmpVal >= 65534.0) {
            this.landmarkWeightDA.setShort(pointer, (short)-2);
            return false;
        }
        this.landmarkWeightDA.setShort(pointer, (short)tmpVal);
        return true;
    }

    boolean isInfinity(long pointer) {
        return (this.landmarkWeightDA.getShort(pointer) & 0xFFFF) == 65535;
    }

    int calcWeight(EdgeIteratorState edge, boolean reverse) {
        return (int)(this.weighting.calcWeight(edge, reverse, -1) / this.factor);
    }

    boolean initActiveLandmarks(int fromNode, int toNode, int[] activeLandmarkIndices, int[] activeFroms, int[] activeTos, boolean reverse) {
        if (fromNode < 0 || toNode < 0) {
            throw new IllegalStateException("from " + fromNode + " and to " + toNode + " nodes have to be 0 or positive to init landmarks");
        }
        int subnetworkFrom = this.subnetworkStorage.getSubnetwork(fromNode);
        int subnetworkTo = this.subnetworkStorage.getSubnetwork(toNode);
        if (subnetworkFrom <= 0 || subnetworkTo <= 0) {
            return false;
        }
        if (subnetworkFrom != subnetworkTo) {
            throw new ConnectionNotFoundException("Connection between locations not found. Different subnetworks " + subnetworkFrom + " vs. " + subnetworkTo, new HashMap<String, Object>());
        }
        int[] tmpIDs = this.landmarkIDs.get(subnetworkFrom);
        ArrayList<MapEntry<Integer, Integer>> list = new ArrayList<MapEntry<Integer, Integer>>(tmpIDs.length);
        int lmIndex = 0;
        while (lmIndex < tmpIDs.length) {
            int fromWeight = this.getFromWeight(lmIndex, toNode) - this.getFromWeight(lmIndex, fromNode);
            int toWeight = this.getToWeight(lmIndex, fromNode) - this.getToWeight(lmIndex, toNode);
            list.add(new MapEntry<Integer, Integer>(reverse ? Math.max(-fromWeight, -toWeight) : Math.max(fromWeight, toWeight), lmIndex));
            ++lmIndex;
        }
        Collections.sort(list, SORT_BY_WEIGHT);
        if (activeLandmarkIndices[0] >= 0) {
            IntHashSet set = new IntHashSet(activeLandmarkIndices.length);
            set.addAll(activeLandmarkIndices);
            int existingLandmarkCounter = 0;
            int COUNT = Math.min(activeLandmarkIndices.length - 2, 2);
            int i = 0;
            while (i < activeLandmarkIndices.length) {
                if (i < activeLandmarkIndices.length - COUNT + existingLandmarkCounter) {
                    activeLandmarkIndices[i] = (Integer)((Map.Entry)list.get(i)).getValue();
                    if (set.contains(activeLandmarkIndices[i])) {
                        ++existingLandmarkCounter;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < activeLandmarkIndices.length) {
                activeLandmarkIndices[i] = (Integer)((Map.Entry)list.get(i)).getValue();
                ++i;
            }
        }
        int i = 0;
        while (i < activeLandmarkIndices.length) {
            int lmIndex2 = activeLandmarkIndices[i];
            activeFroms[i] = this.getFromWeight(lmIndex2, toNode);
            activeTos[i] = this.getToWeight(lmIndex2, toNode);
            ++i;
        }
        return true;
    }

    public int getLandmarkCount() {
        return this.landmarks;
    }

    public int[] getLandmarks(int subnetwork) {
        return this.landmarkIDs.get(subnetwork);
    }

    public int getSubnetworksWithLandmarks() {
        return this.landmarkIDs.size();
    }

    public boolean isEmpty() {
        return this.landmarkIDs.size() < 2;
    }

    public String toString() {
        String str = "";
        for (int[] ints : this.landmarkIDs) {
            if (!str.isEmpty()) {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + Arrays.toString(ints);
        }
        return str;
    }

    String getLandmarksAsGeoJSON() {
        NodeAccess na = this.graph.getNodeAccess();
        String str = "";
        int subnetwork = 1;
        while (subnetwork < this.landmarkIDs.size()) {
            int[] lmArray = this.landmarkIDs.get(subnetwork);
            int lmIdx = 0;
            while (lmIdx < lmArray.length) {
                int index = lmArray[lmIdx];
                if (!str.isEmpty()) {
                    str = String.valueOf(str) + ",";
                }
                str = String.valueOf(str) + "{ \"type\": \"Feature\", \"geometry\": {\"type\": \"Point\", \"coordinates\": [" + na.getLon(index) + ", " + na.getLat(index) + "]},";
                str = String.valueOf(str) + "  \"properties\":{\"node_index\":" + index + "," + "\"subnetwork\":" + subnetwork + "," + "\"lm_index\":" + lmIdx + "}" + "}";
                ++lmIdx;
            }
            ++subnetwork;
        }
        return "{ \"type\": \"FeatureCollection\", \"features\": [" + str + "]}";
    }

    @Override
    public boolean loadExisting() {
        if (this.isInitialized()) {
            throw new IllegalStateException("Cannot call PrepareLandmarks.loadExisting if already initialized");
        }
        if (this.landmarkWeightDA.loadExisting()) {
            long maxBytes;
            if (!this.subnetworkStorage.loadExisting()) {
                throw new IllegalStateException("landmark weights loaded but not the subnetworks!?");
            }
            int nodes = this.landmarkWeightDA.getHeader(0);
            if (nodes != this.graph.getNodes()) {
                throw new IllegalArgumentException("Cannot load landmark data as written for different graph storage with " + nodes + " nodes, not " + this.graph.getNodes());
            }
            this.landmarks = this.landmarkWeightDA.getHeader(4);
            int subnetworks = this.landmarkWeightDA.getHeader(8);
            this.factor = (double)this.landmarkWeightDA.getHeader(12) / 1000000.0;
            this.LM_ROW_LENGTH = this.landmarks * 4;
            long bytePos = maxBytes = this.LM_ROW_LENGTH * (long)nodes;
            int j = 0;
            while (j < subnetworks) {
                int[] tmpLandmarks = new int[this.landmarks];
                int i = 0;
                while (i < tmpLandmarks.length) {
                    tmpLandmarks[i] = this.landmarkWeightDA.getInt(bytePos);
                    bytePos += 4L;
                    ++i;
                }
                this.landmarkIDs.add(tmpLandmarks);
                ++j;
            }
            this.initialized = true;
            return true;
        }
        return false;
    }

    @Override
    public LandmarkStorage create(long byteCount) {
        throw new IllegalStateException("Do not call LandmarkStore.create directly");
    }

    @Override
    public void flush() {
        this.landmarkWeightDA.flush();
        this.subnetworkStorage.flush();
    }

    @Override
    public void close() {
        this.landmarkWeightDA.close();
        this.subnetworkStorage.close();
    }

    @Override
    public boolean isClosed() {
        return this.landmarkWeightDA.isClosed();
    }

    @Override
    public long getCapacity() {
        return this.landmarkWeightDA.getCapacity() + this.subnetworkStorage.getCapacity();
    }

    static GHPoint createPoint(Graph graph, int nodeId) {
        return new GHPoint(graph.getNodeAccess().getLatitude(nodeId), graph.getNodeAccess().getLongitude(nodeId));
    }

    private static class BlockedEdgesFilter
    implements EdgeFilter {
        private final IntHashSet blockedEdges;
        private final FlagEncoder encoder;
        private final boolean fwd;
        private final boolean bwd;

        public BlockedEdgesFilter(FlagEncoder encoder, boolean bwd, boolean fwd, IntHashSet blockedEdges) {
            this.encoder = encoder;
            this.bwd = bwd;
            this.fwd = fwd;
            this.blockedEdges = blockedEdges;
        }

        @Override
        public final boolean accept(EdgeIteratorState iter) {
            boolean blocked = this.blockedEdges.contains(iter.getEdge());
            return this.fwd && iter.isForward(this.encoder) && !blocked || this.bwd && iter.isBackward(this.encoder) && !blocked;
        }

        public boolean acceptsBackward() {
            return this.bwd;
        }

        public boolean acceptsForward() {
            return this.fwd;
        }

        public String toString() {
            return String.valueOf(this.encoder.toString()) + ", bwd:" + this.bwd + ", fwd:" + this.fwd;
        }
    }

    private static class LandmarkExplorer
    extends DijkstraBidirectionRef {
        private int lastNode;
        private boolean from;
        private final LandmarkStorage lms;

        public LandmarkExplorer(Graph g, LandmarkStorage lms, Weighting weighting, TraversalMode tMode) {
            super(g, weighting, tMode);
            this.lms = lms;
        }

        public void setFilter(IntHashSet set, boolean bwd, boolean fwd) {
            BlockedEdgesFilter ef = new BlockedEdgesFilter(this.flagEncoder, bwd, fwd, set);
            this.outEdgeExplorer = this.graph.createEdgeExplorer(ef);
            this.inEdgeExplorer = this.graph.createEdgeExplorer(ef);
        }

        int getFromCount() {
            return this.bestWeightMapFrom.size();
        }

        int getToCount() {
            return this.bestWeightMapTo.size();
        }

        public int getLastNode() {
            return this.lastNode;
        }

        public void runAlgo(boolean from) {
            this.setUpdateBestPath(false);
            if (from) {
                this.finishedTo = true;
            } else {
                this.finishedFrom = true;
            }
            this.from = from;
            super.runAlgo();
        }

        @Override
        public boolean finished() {
            if (this.from) {
                this.lastNode = this.currFrom.adjNode;
                return this.finishedFrom;
            }
            this.lastNode = this.currTo.adjNode;
            return this.finishedTo;
        }

        public boolean setSubnetworks(final byte[] subnetworks, final int subnetworkId) {
            if (subnetworkId > 127) {
                throw new IllegalStateException("Too many subnetworks " + subnetworkId);
            }
            final AtomicBoolean failed = new AtomicBoolean(false);
            IntObjectMap map = this.from ? this.bestWeightMapFrom : this.bestWeightMapTo;
            map.forEach(new IntObjectPredicate<SPTEntry>(){

                @Override
                public boolean apply(int nodeId, SPTEntry value) {
                    byte sn = subnetworks[nodeId];
                    if (sn != subnetworkId) {
                        if (sn != -1 && sn != 0) {
                            LOGGER.error("subnetworkId for node " + nodeId + " (" + LandmarkStorage.createPoint(LandmarkExplorer.this.graph, nodeId) + ") already set (" + sn + "). " + "Cannot change to " + subnetworkId);
                            failed.set(true);
                            return false;
                        }
                        subnetworks[nodeId] = (byte)subnetworkId;
                    }
                    return true;
                }
            });
            return failed.get();
        }

        public void initLandmarkWeights(final int lmIdx, int lmNodeId, final long rowSize, final int offset) {
            IntObjectMap map = this.from ? this.bestWeightMapFrom : this.bestWeightMapTo;
            final AtomicInteger maxedout = new AtomicInteger(0);
            final MapEntry<Double, Double> finalMaxWeight = new MapEntry<Double, Double>(0.0, 0.0);
            map.forEach(new IntObjectProcedure<SPTEntry>(){

                @Override
                public void apply(int nodeId, SPTEntry b) {
                    if (!LandmarkExplorer.this.lms.setWeight((long)nodeId * rowSize + (long)(lmIdx * 4) + (long)offset, b.weight)) {
                        maxedout.incrementAndGet();
                        finalMaxWeight.setValue(Math.max(b.weight, (Double)finalMaxWeight.getValue()));
                    }
                }
            });
            if ((double)maxedout.get() / (double)map.size() > 0.1) {
                LOGGER.warn("landmark " + lmIdx + " (" + this.nodeAccess.getLatitude(lmNodeId) + "," + this.nodeAccess.getLongitude(lmNodeId) + "): " + "too many weights were maxed out (" + maxedout.get() + "/" + map.size() + "). Use a bigger factor than " + this.lms.factor + ". For example use the following in the config.properties: weighting=" + this.weighting.getName() + "|maximum=" + (Double)finalMaxWeight.getValue() * 1.2);
            }
        }
    }

    static final class RequireBothDirectionsEdgeFilter
    implements EdgeFilter {
        private FlagEncoder flagEncoder;

        public RequireBothDirectionsEdgeFilter(FlagEncoder flagEncoder) {
            this.flagEncoder = flagEncoder;
        }

        @Override
        public boolean accept(EdgeIteratorState edgeState) {
            return this.flagEncoder.isForward(edgeState.getFlags()) && this.flagEncoder.isBackward(edgeState.getFlags());
        }
    }
}

