/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.coll.GHTreeMapComposed;
import com.graphhopper.routing.AStarBidirectionCH;
import com.graphhopper.routing.AbstractBidirAlgo;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PreparationWeighting;
import com.graphhopper.routing.util.AbstractAlgoPreparation;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.LevelEdgeFilter;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.CHGraphImpl;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.util.CHEdgeExplorer;
import com.graphhopper.util.CHEdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareContractionHierarchies
extends AbstractAlgoPreparation
implements RoutingAlgorithmFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Directory dir;
    private final PreparationWeighting prepareWeighting;
    private final Weighting weighting;
    private final TraversalMode traversalMode;
    private final GraphHopperStorage ghStorage;
    private final CHGraphImpl prepareGraph;
    private final Random rand = new Random(123L);
    private final StopWatch allSW = new StopWatch();
    private NodeContractor nodeContractor;
    private CHEdgeExplorer vehicleAllExplorer;
    private CHEdgeExplorer vehicleAllTmpExplorer;
    private CHEdgeExplorer calcPrioAllExplorer;
    private int maxLevel;
    private GHTreeMapComposed sortedNodes;
    private int[] oldPriorities;
    private double meanDegree;
    private int periodicUpdatesPercentage = 20;
    private int lastNodesLazyUpdatePercentage = 10;
    private int neighborUpdatePercentage = 20;
    private double nodesContractedPercentage = 100.0;
    private double logMessagesPercentage = 20.0;
    private double dijkstraTime;
    private double periodTime;
    private double lazyTime;
    private double neighborTime;

    public PrepareContractionHierarchies(Directory dir, GraphHopperStorage ghStorage, CHGraph chGraph, Weighting weighting, TraversalMode traversalMode) {
        this.dir = dir;
        this.ghStorage = ghStorage;
        this.prepareGraph = (CHGraphImpl)chGraph;
        this.traversalMode = traversalMode;
        this.weighting = weighting;
        this.prepareWeighting = new PreparationWeighting(weighting);
    }

    public PrepareContractionHierarchies setPeriodicUpdates(int periodicUpdates) {
        if (periodicUpdates < 0) {
            return this;
        }
        if (periodicUpdates > 100) {
            throw new IllegalArgumentException("periodicUpdates has to be in [0, 100], to disable it use 0");
        }
        this.periodicUpdatesPercentage = periodicUpdates;
        return this;
    }

    public PrepareContractionHierarchies setLazyUpdates(int lazyUpdates) {
        if (lazyUpdates < 0) {
            return this;
        }
        if (lazyUpdates > 100) {
            throw new IllegalArgumentException("lazyUpdates has to be in [0, 100], to disable it use 0");
        }
        this.lastNodesLazyUpdatePercentage = lazyUpdates;
        return this;
    }

    public PrepareContractionHierarchies setNeighborUpdates(int neighborUpdates) {
        if (neighborUpdates < 0) {
            return this;
        }
        if (neighborUpdates > 100) {
            throw new IllegalArgumentException("neighborUpdates has to be in [0, 100], to disable it use 0");
        }
        this.neighborUpdatePercentage = neighborUpdates;
        return this;
    }

    public PrepareContractionHierarchies setLogMessages(double logMessages) {
        if (logMessages >= 0.0) {
            this.logMessagesPercentage = logMessages;
        }
        return this;
    }

    public PrepareContractionHierarchies setContractedNodes(double nodesContracted) {
        if (nodesContracted < 0.0) {
            return this;
        }
        if (nodesContracted > 100.0) {
            throw new IllegalArgumentException("setNodesContracted can be 100% maximum");
        }
        this.nodesContractedPercentage = nodesContracted;
        return this;
    }

    @Override
    public void doWork() {
        this.allSW.start();
        super.doWork();
        this.initFromGraph();
        if (!this.prepareNodes()) {
            return;
        }
        this.contractNodes();
    }

    @Override
    public RoutingAlgorithm createAlgo(Graph graph, AlgorithmOptions opts) {
        AbstractBidirAlgo algo;
        if ("astarbi".equals(opts.getAlgorithm())) {
            AStarBidirectionCH tmpAlgo = new AStarBidirectionCH(graph, this.prepareWeighting, this.traversalMode);
            tmpAlgo.setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts, graph.getNodeAccess()));
            algo = tmpAlgo;
        } else if ("dijkstrabi".equals(opts.getAlgorithm())) {
            algo = opts.getHints().getBool("stall_on_demand", true) ? new DijkstraBidirectionCH(graph, this.prepareWeighting, this.traversalMode) : new DijkstraBidirectionCHNoSOD(graph, this.prepareWeighting, this.traversalMode);
        } else {
            throw new IllegalArgumentException("Algorithm " + opts.getAlgorithm() + " not supported for Contraction Hierarchies. Try with ch.disable=true");
        }
        algo.setMaxVisitedNodes(opts.getMaxVisitedNodes());
        algo.setEdgeFilter(new LevelEdgeFilter(this.prepareGraph));
        return algo;
    }

    private void initFromGraph() {
        this.ghStorage.freeze();
        FlagEncoder prepareFlagEncoder = this.prepareWeighting.getFlagEncoder();
        final DefaultEdgeFilter allFilter = new DefaultEdgeFilter(prepareFlagEncoder, true, true);
        LevelEdgeFilter accessWithLevelFilter = new LevelEdgeFilter(this.prepareGraph){

            @Override
            public final boolean accept(EdgeIteratorState edgeState) {
                return super.accept(edgeState) && allFilter.accept(edgeState);
            }
        };
        this.maxLevel = this.prepareGraph.getNodes() + 1;
        this.vehicleAllExplorer = this.prepareGraph.createEdgeExplorer(allFilter);
        this.vehicleAllTmpExplorer = this.prepareGraph.createEdgeExplorer(allFilter);
        this.calcPrioAllExplorer = this.prepareGraph.createEdgeExplorer(accessWithLevelFilter);
        this.sortedNodes = new GHTreeMapComposed();
        this.oldPriorities = new int[this.prepareGraph.getNodes()];
        this.nodeContractor = new NodeContractor(this.dir, this.ghStorage, this.prepareGraph, this.weighting, this.traversalMode);
        this.nodeContractor.initFromGraph();
    }

    private boolean prepareNodes() {
        int nodes = this.prepareGraph.getNodes();
        int node = 0;
        while (node < nodes) {
            this.prepareGraph.setLevel(node, this.maxLevel);
            ++node;
        }
        node = 0;
        while (node < nodes) {
            int priority = this.oldPriorities[node] = this.calculatePriority(node);
            this.sortedNodes.insert(node, priority);
            ++node;
        }
        return !this.sortedNodes.isEmpty();
    }

    private void contractNodes() {
        this.meanDegree = this.prepareGraph.getAllEdges().getMaxId() / this.prepareGraph.getNodes();
        int level = 1;
        long counter = 0L;
        int initSize = this.sortedNodes.getSize();
        long logSize = Math.round(Math.max(10.0, (double)(this.sortedNodes.getSize() / 100) * this.logMessagesPercentage));
        if (this.logMessagesPercentage == 0.0) {
            logSize = Integer.MAX_VALUE;
        }
        boolean periodicUpdate = true;
        StopWatch periodSW = new StopWatch();
        int updateCounter = 0;
        long periodicUpdatesCount = Math.round(Math.max(10.0, (double)this.sortedNodes.getSize() / 100.0 * (double)this.periodicUpdatesPercentage));
        if (this.periodicUpdatesPercentage == 0) {
            periodicUpdate = false;
        }
        long lastNodesLazyUpdates = Math.round((double)this.sortedNodes.getSize() / 100.0 * (double)this.lastNodesLazyUpdatePercentage);
        long nodesToAvoidContract = Math.round((100.0 - this.nodesContractedPercentage) / 100.0 * (double)this.sortedNodes.getSize());
        StopWatch lazySW = new StopWatch();
        boolean neighborUpdate = true;
        if (this.neighborUpdatePercentage == 0) {
            neighborUpdate = false;
        }
        StopWatch neighborSW = new StopWatch();
        while (!this.sortedNodes.isEmpty()) {
            if (periodicUpdate && counter > 0L && counter % periodicUpdatesCount == 0L) {
                periodSW.start();
                this.sortedNodes.clear();
                int len = this.prepareGraph.getNodes();
                int node = 0;
                while (node < len) {
                    if (this.prepareGraph.getLevel(node) == this.maxLevel) {
                        int priority = this.oldPriorities[node] = this.calculatePriority(node);
                        this.sortedNodes.insert(node, priority);
                    }
                    ++node;
                }
                periodSW.stop();
                ++updateCounter;
                if (this.sortedNodes.isEmpty()) {
                    throw new IllegalStateException("Cannot prepare as no unprepared nodes where found. Called preparation twice?");
                }
            }
            if (counter % logSize == 0L) {
                this.dijkstraTime += (double)this.nodeContractor.getDijkstraSeconds();
                this.periodTime += (double)periodSW.getSeconds();
                this.lazyTime += (double)lazySW.getSeconds();
                this.neighborTime += (double)neighborSW.getSeconds();
                this.logger.info(String.valueOf(Helper.nf(counter)) + ", updates:" + updateCounter + ", nodes: " + Helper.nf(this.sortedNodes.getSize()) + ", shortcuts:" + Helper.nf(this.nodeContractor.getAddedShortcutsCount()) + ", dijkstras:" + Helper.nf(this.nodeContractor.getDijkstraCount()) + ", " + this.getTimesAsString() + ", meanDegree:" + (long)this.meanDegree + ", algo:" + this.nodeContractor.getPrepareAlgoMemoryUsage() + ", " + Helper.getMemInfo());
                this.nodeContractor.resetDijkstraTime();
                periodSW = new StopWatch();
                lazySW = new StopWatch();
                neighborSW = new StopWatch();
            }
            ++counter;
            int polledNode = this.sortedNodes.pollKey();
            if (!this.sortedNodes.isEmpty() && (long)this.sortedNodes.getSize() < lastNodesLazyUpdates) {
                lazySW.start();
                int priority = this.oldPriorities[polledNode] = this.calculatePriority(polledNode);
                if (priority > this.sortedNodes.peekValue()) {
                    this.sortedNodes.insert(polledNode, priority);
                    lazySW.stop();
                    continue;
                }
                lazySW.stop();
            }
            this.nodeContractor.setMaxVisitedNodes(this.getMaxVisitedNodesEstimate());
            long degree = this.nodeContractor.contractNode(polledNode);
            this.meanDegree = (this.meanDegree * 2.0 + (double)degree) / 3.0;
            this.prepareGraph.setLevel(polledNode, level);
            ++level;
            if ((long)this.sortedNodes.getSize() < nodesToAvoidContract) break;
            CHEdgeIterator iter = this.vehicleAllExplorer.setBaseNode(polledNode);
            while (iter.next()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException("Thread was interrupted");
                }
                int nn = iter.getAdjNode();
                if (this.prepareGraph.getLevel(nn) != this.maxLevel) continue;
                if (neighborUpdate && this.rand.nextInt(100) < this.neighborUpdatePercentage) {
                    neighborSW.start();
                    int oldPrio = this.oldPriorities[nn];
                    int priority = this.oldPriorities[nn] = this.calculatePriority(nn);
                    if (priority != oldPrio) {
                        this.sortedNodes.update(nn, oldPrio, priority);
                    }
                    neighborSW.stop();
                }
                this.prepareGraph.disconnect(this.vehicleAllTmpExplorer, iter);
            }
        }
        this.close();
        this.dijkstraTime += (double)this.nodeContractor.getDijkstraSeconds();
        this.periodTime += (double)periodSW.getSeconds();
        this.lazyTime += (double)lazySW.getSeconds();
        this.neighborTime += (double)neighborSW.getSeconds();
        this.logger.info("took:" + (int)this.allSW.stop().getSeconds() + ", new shortcuts: " + Helper.nf(this.nodeContractor.getAddedShortcutsCount()) + ", " + this.prepareWeighting + ", dijkstras:" + this.nodeContractor.getDijkstraCount() + ", " + this.getTimesAsString() + ", meanDegree:" + (long)this.meanDegree + ", initSize:" + initSize + ", periodic:" + this.periodicUpdatesPercentage + ", lazy:" + this.lastNodesLazyUpdatePercentage + ", neighbor:" + this.neighborUpdatePercentage + ", " + Helper.getMemInfo());
    }

    public void close() {
        this.nodeContractor.close();
        this.sortedNodes = null;
        this.oldPriorities = null;
    }

    public long getDijkstraCount() {
        return this.nodeContractor.getDijkstraCount();
    }

    public int getShortcuts() {
        return this.nodeContractor.getAddedShortcutsCount();
    }

    public double getLazyTime() {
        return this.lazyTime;
    }

    public double getPeriodTime() {
        return this.periodTime;
    }

    public double getDijkstraTime() {
        return this.dijkstraTime;
    }

    public double getNeighborTime() {
        return this.neighborTime;
    }

    public Weighting getWeighting() {
        return this.prepareGraph.getWeighting();
    }

    private String getTimesAsString() {
        return "t(dijk):" + Helper.round2(this.dijkstraTime) + ", t(period):" + Helper.round2(this.periodTime) + ", t(lazy):" + Helper.round2(this.lazyTime) + ", t(neighbor):" + Helper.round2(this.neighborTime);
    }

    private int calculatePriority(int node) {
        this.nodeContractor.setMaxVisitedNodes(this.getMaxVisitedNodesEstimate());
        NodeContractor.CalcShortcutsResult calcShortcutsResult = this.nodeContractor.calcShortcutCount(node);
        int originalEdgesCount = calcShortcutsResult.originalEdgesCount;
        int contractedNeighbors = 0;
        int degree = 0;
        CHEdgeIterator iter = this.calcPrioAllExplorer.setBaseNode(node);
        while (iter.next()) {
            ++degree;
            if (!iter.isShortcut()) continue;
            ++contractedNeighbors;
        }
        int edgeDifference = calcShortcutsResult.shortcutsCount - degree;
        return 10 * edgeDifference + originalEdgesCount + contractedNeighbors;
    }

    private int getMaxVisitedNodesEstimate() {
        return (int)this.meanDegree * 100;
    }

    public String toString() {
        return "prepare|dijkstrabi|ch";
    }
}

