/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.RoutingAlgorithmFactoryDecorator;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.AbstractWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.CHGraph;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CHAlgoFactoryDecorator
implements RoutingAlgorithmFactoryDecorator {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final List<PrepareContractionHierarchies> preparations = new ArrayList<PrepareContractionHierarchies>();
    private final List<Weighting> weightings = new ArrayList<Weighting>();
    private final Set<String> weightingsAsStrings = new LinkedHashSet<String>();
    private boolean disablingAllowed = false;
    private boolean enabled = true;
    private int preparationThreads;
    private ExecutorService threadPool;
    private int preparationPeriodicUpdates = -1;
    private int preparationLazyUpdates = -1;
    private int preparationNeighborUpdates = -1;
    private int preparationContractedNodes = -1;
    private double preparationLogMessages = -1.0;

    public CHAlgoFactoryDecorator() {
        this.setPreparationThreads(1);
        this.setWeightingsAsStrings(Arrays.asList(this.getDefaultWeighting()));
    }

    @Override
    public void init(CmdArgs args) {
        if (!args.get("prepare.threads", "").isEmpty()) {
            throw new IllegalStateException("Use prepare.ch.threads instead of prepare.threads");
        }
        if (!args.get("prepare.chWeighting", "").isEmpty() || !args.get("prepare.chWeightings", "").isEmpty()) {
            throw new IllegalStateException("Use prepare.ch.weightings and a comma separated list instead of prepare.chWeighting or prepare.chWeightings");
        }
        this.setPreparationThreads(args.getInt("prepare.ch.threads", this.getPreparationThreads()));
        String chWeightingsStr = args.get("prepare.ch.weightings", "");
        if ("no".equals(chWeightingsStr)) {
            this.weightingsAsStrings.clear();
        } else if (!chWeightingsStr.isEmpty()) {
            List<String> tmpCHWeightingList = Arrays.asList(chWeightingsStr.split(","));
            this.setWeightingsAsStrings(tmpCHWeightingList);
        }
        boolean enableThis = !this.weightingsAsStrings.isEmpty();
        this.setEnabled(enableThis);
        if (enableThis) {
            this.setDisablingAllowed(args.getBool("routing.ch.disabling_allowed", this.isDisablingAllowed()));
        }
        this.setPreparationPeriodicUpdates(args.getInt("prepare.ch.updates.periodic", this.getPreparationPeriodicUpdates()));
        this.setPreparationLazyUpdates(args.getInt("prepare.ch.updates.lazy", this.getPreparationLazyUpdates()));
        this.setPreparationNeighborUpdates(args.getInt("prepare.ch.updates.neighbor", this.getPreparationNeighborUpdates()));
        this.setPreparationContractedNodes(args.getInt("prepare.ch.contracted_nodes", this.getPreparationContractedNodes()));
        this.setPreparationLogMessages(args.getDouble("prepare.ch.log_messages", this.getPreparationLogMessages()));
    }

    public int getPreparationPeriodicUpdates() {
        return this.preparationPeriodicUpdates;
    }

    public CHAlgoFactoryDecorator setPreparationPeriodicUpdates(int preparePeriodicUpdates) {
        this.preparationPeriodicUpdates = preparePeriodicUpdates;
        return this;
    }

    public int getPreparationContractedNodes() {
        return this.preparationContractedNodes;
    }

    public CHAlgoFactoryDecorator setPreparationContractedNodes(int prepareContractedNodes) {
        this.preparationContractedNodes = prepareContractedNodes;
        return this;
    }

    public int getPreparationLazyUpdates() {
        return this.preparationLazyUpdates;
    }

    public CHAlgoFactoryDecorator setPreparationLazyUpdates(int prepareLazyUpdates) {
        this.preparationLazyUpdates = prepareLazyUpdates;
        return this;
    }

    public double getPreparationLogMessages() {
        return this.preparationLogMessages;
    }

    public CHAlgoFactoryDecorator setPreparationLogMessages(double prepareLogMessages) {
        this.preparationLogMessages = prepareLogMessages;
        return this;
    }

    public int getPreparationNeighborUpdates() {
        return this.preparationNeighborUpdates;
    }

    public CHAlgoFactoryDecorator setPreparationNeighborUpdates(int prepareNeighborUpdates) {
        this.preparationNeighborUpdates = prepareNeighborUpdates;
        return this;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    public final CHAlgoFactoryDecorator setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public final boolean isDisablingAllowed() {
        return this.disablingAllowed || !this.isEnabled();
    }

    public final CHAlgoFactoryDecorator setDisablingAllowed(boolean disablingAllowed) {
        this.disablingAllowed = disablingAllowed;
        return this;
    }

    public CHAlgoFactoryDecorator addWeighting(Weighting weighting) {
        this.weightings.add(weighting);
        return this;
    }

    public CHAlgoFactoryDecorator addWeighting(String weighting) {
        this.weightingsAsStrings.add(weighting);
        return this;
    }

    public CHAlgoFactoryDecorator addPreparation(PrepareContractionHierarchies pch) {
        this.preparations.add(pch);
        int lastIndex = this.preparations.size() - 1;
        if (lastIndex >= this.weightings.size()) {
            throw new IllegalStateException("Cannot access weighting for PrepareContractionHierarchies with " + pch.getWeighting() + ". Call add(Weighting) before");
        }
        if (this.preparations.get(lastIndex).getWeighting() != this.weightings.get(lastIndex)) {
            throw new IllegalArgumentException("Weighting of PrepareContractionHierarchies " + this.preparations.get(lastIndex).getWeighting() + " needs to be identical to previously added " + this.weightings.get(lastIndex));
        }
        return this;
    }

    public final boolean hasWeightings() {
        return !this.weightings.isEmpty();
    }

    public final List<Weighting> getWeightings() {
        return this.weightings;
    }

    public CHAlgoFactoryDecorator setWeightingsAsStrings(String ... weightingNames) {
        return this.setWeightingsAsStrings(Arrays.asList(weightingNames));
    }

    public List<String> getWeightingsAsStrings() {
        if (this.weightingsAsStrings.isEmpty()) {
            throw new IllegalStateException("Potential bug: weightingsAsStrings is empty");
        }
        return new ArrayList<String>(this.weightingsAsStrings);
    }

    public CHAlgoFactoryDecorator setWeightingsAsStrings(List<String> weightingList) {
        if (weightingList.isEmpty()) {
            throw new IllegalArgumentException("It is not allowed to pass an emtpy weightingList");
        }
        this.weightingsAsStrings.clear();
        for (String strWeighting : weightingList) {
            strWeighting = Helper.toLowerCase(strWeighting);
            strWeighting = strWeighting.trim();
            this.addWeighting(strWeighting);
        }
        return this;
    }

    private String getDefaultWeighting() {
        return this.weightingsAsStrings.isEmpty() ? "fastest" : this.weightingsAsStrings.iterator().next();
    }

    public List<PrepareContractionHierarchies> getPreparations() {
        return this.preparations;
    }

    @Override
    public RoutingAlgorithmFactory getDecoratedAlgorithmFactory(RoutingAlgorithmFactory defaultAlgoFactory, HintsMap map) {
        boolean disableCH = map.getBool("ch.disable", false);
        if (!this.isEnabled() || this.disablingAllowed && disableCH) {
            return defaultAlgoFactory;
        }
        if (this.preparations.isEmpty()) {
            throw new IllegalStateException("No preparations added to this decorator");
        }
        if (map.getWeighting().isEmpty()) {
            map.setWeighting(this.getDefaultWeighting());
        }
        String entriesStr = "";
        for (PrepareContractionHierarchies p : this.preparations) {
            if (p.getWeighting().matches(map)) {
                return p;
            }
            entriesStr = String.valueOf(entriesStr) + p.getWeighting() + ", ";
        }
        throw new IllegalArgumentException("Cannot find CH RoutingAlgorithmFactory for weighting map " + map + " in entries " + entriesStr);
    }

    public int getPreparationThreads() {
        return this.preparationThreads;
    }

    public void setPreparationThreads(int preparationThreads) {
        this.preparationThreads = preparationThreads;
        this.threadPool = Executors.newFixedThreadPool(preparationThreads);
    }

    public void prepare(final StorableProperties properties) {
        ExecutorCompletionService<String> completionService = new ExecutorCompletionService<String>(this.threadPool);
        int counter = 0;
        for (final PrepareContractionHierarchies prepare : this.getPreparations()) {
            this.LOGGER.info(String.valueOf(++counter) + "/" + this.getPreparations().size() + " calling CH prepare.doWork for " + prepare.getWeighting() + " ... (" + Helper.getMemInfo() + ")");
            final String name = AbstractWeighting.weightingToFileName(prepare.getWeighting());
            completionService.submit(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setName(name);
                    prepare.doWork();
                    properties.put("prepare.ch.date." + name, Helper.createFormatter().format(new Date()));
                }
            }, name);
        }
        this.threadPool.shutdown();
        try {
            int i = 0;
            while (i < this.getPreparations().size()) {
                completionService.take().get();
                ++i;
            }
        }
        catch (Exception e) {
            this.threadPool.shutdownNow();
            throw new RuntimeException(e);
        }
    }

    public void createPreparations(GraphHopperStorage ghStorage, TraversalMode traversalMode) {
        if (!this.isEnabled() || !this.preparations.isEmpty()) {
            return;
        }
        if (this.weightings.isEmpty()) {
            throw new IllegalStateException("No CH weightings found");
        }
        traversalMode = this.getNodeBase();
        for (Weighting weighting : this.getWeightings()) {
            PrepareContractionHierarchies tmpPrepareCH = new PrepareContractionHierarchies(new GHDirectory("", DAType.RAM_INT), ghStorage, ghStorage.getGraph(CHGraph.class, weighting), weighting, traversalMode);
            tmpPrepareCH.setPeriodicUpdates(this.preparationPeriodicUpdates).setLazyUpdates(this.preparationLazyUpdates).setNeighborUpdates(this.preparationNeighborUpdates).setLogMessages(this.preparationLogMessages);
            this.addPreparation(tmpPrepareCH);
        }
    }

    public TraversalMode getNodeBase() {
        return TraversalMode.NODE_BASED;
    }
}

