/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.AStar;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.AlternativeRoute;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.DijkstraOneToMany;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactory;
import com.graphhopper.routing.weighting.BeelineWeightApproximator;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.Helper;

public class RoutingAlgorithmFactorySimple
implements RoutingAlgorithmFactory {
    @Override
    public RoutingAlgorithm createAlgo(Graph g, AlgorithmOptions opts) {
        RoutingAlgorithm ra;
        String algoStr = opts.getAlgorithm();
        if ("dijkstrabi".equalsIgnoreCase(algoStr)) {
            ra = new DijkstraBidirectionRef(g, opts.getWeighting(), opts.getTraversalMode());
        } else if ("dijkstra".equalsIgnoreCase(algoStr)) {
            ra = new Dijkstra(g, opts.getWeighting(), opts.getTraversalMode());
        } else if ("astarbi".equalsIgnoreCase(algoStr)) {
            AStarBidirection aStarBi = new AStarBidirection(g, opts.getWeighting(), opts.getTraversalMode());
            aStarBi.setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts, g.getNodeAccess()));
            ra = aStarBi;
        } else if ("dijkstra_one_to_many".equalsIgnoreCase(algoStr)) {
            ra = new DijkstraOneToMany(g, opts.getWeighting(), opts.getTraversalMode());
        } else if ("astar".equalsIgnoreCase(algoStr)) {
            AStar aStar = new AStar(g, opts.getWeighting(), opts.getTraversalMode());
            aStar.setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astar", opts, g.getNodeAccess()));
            ra = aStar;
        } else if ("alternative_route".equalsIgnoreCase(algoStr)) {
            AlternativeRoute altRouteAlgo = new AlternativeRoute(g, opts.getWeighting(), opts.getTraversalMode());
            altRouteAlgo.setMaxPaths(opts.getHints().getInt("alternative_route.max_paths", 2));
            altRouteAlgo.setMaxWeightFactor(opts.getHints().getDouble("alternative_route.max_weight_factor", 1.4));
            altRouteAlgo.setMaxShareFactor(opts.getHints().getDouble("alternative_route.max_share_factor", 0.6));
            altRouteAlgo.setMinPlateauFactor(opts.getHints().getDouble("alternative_route.min_plateau_factor", 0.2));
            altRouteAlgo.setMaxExplorationFactor(opts.getHints().getDouble("alternative_route.max_exploration_factor", 1.0));
            ra = altRouteAlgo;
        } else {
            throw new IllegalArgumentException("Algorithm " + algoStr + " not found in " + this.getClass().getName());
        }
        ra.setMaxVisitedNodes(opts.getMaxVisitedNodes());
        return ra;
    }

    public static WeightApproximator getApproximation(String prop, AlgorithmOptions opts, NodeAccess na) {
        String approxAsStr = opts.getHints().get(String.valueOf(prop) + ".approximation", "BeelineSimplification");
        double epsilon = opts.getHints().getDouble(String.valueOf(prop) + ".epsilon", 1.0);
        BeelineWeightApproximator approx = new BeelineWeightApproximator(na, opts.getWeighting());
        approx.setEpsilon(epsilon);
        if ("BeelineSimplification".equals(approxAsStr)) {
            approx.setDistanceCalc(Helper.DIST_PLANE);
        } else if ("BeelineAccurate".equals(approxAsStr)) {
            approx.setDistanceCalc(Helper.DIST_EARTH);
        } else {
            throw new IllegalArgumentException("Approximation " + approxAsStr + " not found in " + RoutingAlgorithmFactorySimple.class.getName());
        }
        return approx;
    }
}

