/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntObjectMap;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.SPTEntry;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;

public class DijkstraBidirectionCH
extends DijkstraBidirectionCHNoSOD {
    public DijkstraBidirectionCH(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        super(graph, weighting, traversalMode);
    }

    @Override
    public boolean fillEdgesFrom() {
        if (this.pqOpenSetFrom.isEmpty()) {
            return false;
        }
        this.currFrom = (SPTEntry)this.pqOpenSetFrom.poll();
        ++this.visitedCountFrom;
        if (this.entryIsStallable(this.currFrom, this.bestWeightMapFrom, this.inEdgeExplorer, false)) {
            return true;
        }
        this.bestWeightMapOther = this.bestWeightMapTo;
        this.fillEdges(this.currFrom, this.pqOpenSetFrom, this.bestWeightMapFrom, this.outEdgeExplorer, false);
        return true;
    }

    @Override
    public boolean fillEdgesTo() {
        if (this.pqOpenSetTo.isEmpty()) {
            return false;
        }
        this.currTo = (SPTEntry)this.pqOpenSetTo.poll();
        ++this.visitedCountTo;
        if (this.entryIsStallable(this.currTo, this.bestWeightMapTo, this.outEdgeExplorer, true)) {
            return true;
        }
        this.bestWeightMapOther = this.bestWeightMapFrom;
        this.fillEdges(this.currTo, this.pqOpenSetTo, this.bestWeightMapTo, this.inEdgeExplorer, true);
        return true;
    }

    @Override
    public String getName() {
        return "dijkstrabi|ch";
    }

    @Override
    public String toString() {
        return String.valueOf(this.getName()) + "|" + this.weighting;
    }

    private boolean entryIsStallable(SPTEntry entry, IntObjectMap<SPTEntry> bestWeightMap, EdgeExplorer edgeExplorer, boolean reverse) {
        EdgeIterator iter = edgeExplorer.setBaseNode(entry.adjNode);
        while (iter.next()) {
            int traversalId = this.traversalMode.createTraversalId(iter, reverse);
            SPTEntry adjNode = bestWeightMap.get(traversalId);
            if (adjNode == null) continue;
            double d = adjNode.weight;
            boolean bl = !reverse;
            if (!(d + this.weighting.calcWeight(iter, bl, entry.edge) < entry.weight)) continue;
            return true;
        }
        return false;
    }
}

