/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm.conditional;

import com.graphhopper.reader.ConditionalTagInspector;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.osm.conditional.ConditionalParser;
import com.graphhopper.reader.osm.conditional.ConditionalValueParser;
import com.graphhopper.reader.osm.conditional.DateRangeParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalOSMTagInspector
implements ConditionalTagInspector {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<String> tagsToCheck;
    private final ConditionalParser permitParser;
    private final ConditionalParser restrictiveParser;
    private boolean enabledLogs = true;

    public ConditionalOSMTagInspector(Object value, List<String> tagsToCheck, Set<String> restrictiveValues, Set<String> permittedValues) {
        this(tagsToCheck, Arrays.asList(new DateRangeParser((Calendar)value)), restrictiveValues, permittedValues, false);
    }

    public ConditionalOSMTagInspector(List<String> tagsToCheck, List<? extends ConditionalValueParser> valueParsers, Set<String> restrictiveValues, Set<String> permittedValues, boolean enabledLogs) {
        this.tagsToCheck = new ArrayList<String>(tagsToCheck.size());
        for (String tagToCheck : tagsToCheck) {
            this.tagsToCheck.add(String.valueOf(tagToCheck) + ":conditional");
        }
        this.enabledLogs = enabledLogs;
        boolean logUnsupportedFeatures = false;
        this.permitParser = new ConditionalParser(permittedValues, logUnsupportedFeatures);
        this.restrictiveParser = new ConditionalParser(restrictiveValues, logUnsupportedFeatures);
        for (ConditionalValueParser conditionalValueParser : valueParsers) {
            this.permitParser.addConditionalValueParser(conditionalValueParser);
            this.restrictiveParser.addConditionalValueParser(conditionalValueParser);
        }
    }

    public void addValueParser(ConditionalValueParser vp) {
        this.permitParser.addConditionalValueParser(vp);
        this.restrictiveParser.addConditionalValueParser(vp);
    }

    @Override
    public boolean isRestrictedWayConditionallyPermitted(ReaderWay way) {
        return this.applies(way, true);
    }

    @Override
    public boolean isPermittedWayConditionallyRestricted(ReaderWay way) {
        return this.applies(way, false);
    }

    protected boolean applies(ReaderWay way, boolean checkPermissiveValues) {
        int index = 0;
        while (index < this.tagsToCheck.size()) {
            block8: {
                String tagToCheck = this.tagsToCheck.get(index);
                String val = way.getTag(tagToCheck);
                if (val != null && !val.isEmpty()) {
                    block7: {
                        if (!checkPermissiveValues) break block7;
                        if (this.permitParser.checkCondition(val)) {
                            return true;
                        }
                    }
                    try {
                        if (this.restrictiveParser.checkCondition(val)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        if (!this.enabledLogs || val.contains(":")) break block8;
                        this.logger.warn("for way " + way.getId() + " could not parse the conditional value '" + val + "' of tag '" + tagToCheck + "'. Exception:" + e.getMessage());
                    }
                }
            }
            ++index;
        }
        return false;
    }
}

