/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class OSMTagParser {
    private static final Date STATIC_DATE = new Date(-1109469184L);

    public static long parseDuration(String str) throws IllegalArgumentException {
        long seconds = 0L;
        if (str == null) {
            return 0L;
        }
        if (str.startsWith("P")) {
            try {
                Duration dur = DatatypeFactory.newInstance().newDuration(str);
                seconds = dur.getTimeInMillis(STATIC_DATE) / 1000L;
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Cannot parse duration tag value: " + str, ex);
            }
            return seconds;
        }
        try {
            int index = str.indexOf(":");
            if (index > 0) {
                String hourStr = str.substring(0, index);
                String minStr = str.substring(index + 1);
                String secondsStr = "0";
                index = minStr.indexOf(":");
                if (index > 0) {
                    secondsStr = minStr.substring(index + 1, index + 3);
                    minStr = minStr.substring(0, index);
                }
                seconds += (long)Integer.parseInt(hourStr) * 60L * 60L;
                seconds += (long)Integer.parseInt(minStr) * 60L;
                return seconds += (long)Integer.parseInt(secondsStr);
            }
            seconds = Integer.parseInt(str) * 60;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot parse duration tag value: " + str, ex);
        }
        return seconds;
    }
}

