/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.reader.dem.AbstractElevationProvider;
import com.graphhopper.reader.dem.HeightTile;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.Downloader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;

public abstract class AbstractSRTMElevationProvider
extends AbstractElevationProvider {
    private static final BitUtil BIT_UTIL = BitUtil.BIG;
    private final int DEFAULT_WIDTH;
    private final int WIDTH_BYTE_INDEX = 0;
    private final int DEGREE = 1;
    private final GHIntObjectHashMap<HeightTile> cacheData = new GHIntObjectHashMap();
    private final double precision = 1.0E7;
    private final double invPrecision = 1.0E-7;

    public AbstractSRTMElevationProvider(String baseUrl, String cacheDir, String downloaderName, int defaultWidt) {
        super(cacheDir);
        this.baseUrl = baseUrl;
        this.downloader = new Downloader(downloaderName).setTimeout(10000);
        this.DEFAULT_WIDTH = defaultWidt;
    }

    int calcIntKey(double lat, double lon) {
        return (this.down(lat) + 90) * 1000 + this.down(lon) + 180;
    }

    @Override
    public void release() {
        this.cacheData.clear();
        if (this.autoRemoveTemporary && this.dir != null) {
            this.dir.clear();
        }
    }

    @Override
    public void setAutoRemoveTemporaryFiles(boolean autoRemoveTemporary) {
        this.autoRemoveTemporary = autoRemoveTemporary;
    }

    int down(double val) {
        int intVal = (int)val;
        if (val >= 0.0 || (double)intVal - val < 1.0E-7) {
            return intVal;
        }
        return intVal - 1;
    }

    @Override
    public double getEle(double lat, double lon) {
        if (lat >= 60.0 || lat <= -56.0) {
            return 0.0;
        }
        int intKey = this.calcIntKey(lat = (double)((int)(lat * 1.0E7)) / 1.0E7, lon = (double)((int)(lon * 1.0E7)) / 1.0E7);
        HeightTile demProvider = (HeightTile)this.cacheData.get(intKey);
        if (demProvider == null) {
            int width;
            if (!this.cacheDir.exists()) {
                this.cacheDir.mkdirs();
            }
            int minLat = this.down(lat);
            int minLon = this.down(lon);
            String fileName = this.getFileName(lat, lon);
            if (fileName == null) {
                return 0.0;
            }
            DataAccess heights = this.getDirectory().find("dem" + intKey);
            boolean loadExisting = false;
            try {
                loadExisting = heights.loadExisting();
            }
            catch (Exception ex) {
                this.logger.warn("cannot load dem" + intKey + ", error:" + ex.getMessage());
            }
            if (!loadExisting) {
                try {
                    this.updateHeightsFromFile(lat, lon, heights);
                }
                catch (FileNotFoundException ex) {
                    demProvider = new HeightTile(minLat, minLon, this.DEFAULT_WIDTH, this.DEFAULT_WIDTH, 1.0E7, 1, 1);
                    this.cacheData.put(intKey, demProvider);
                    demProvider.setHeights(heights);
                    demProvider.setSeaLevel(true);
                    heights.setSegmentSize(100).create(10L).flush();
                    return 0.0;
                }
            }
            if ((width = (int)(Math.sqrt(heights.getHeader(0)) + 0.5)) == 0) {
                width = this.DEFAULT_WIDTH;
            }
            demProvider = new HeightTile(minLat, minLon, width, width, 1.0E7, 1, 1);
            this.cacheData.put(intKey, demProvider);
            demProvider.setCalcMean(this.calcMean);
            demProvider.setHeights(heights);
        }
        if (demProvider.isSeaLevel()) {
            return 0.0;
        }
        return demProvider.getHeight(lat, lon);
    }

    private void updateHeightsFromFile(double lat, double lon, DataAccess heights) throws FileNotFoundException {
        try {
            byte[] bytes = this.getByteArrayFromFile(lat, lon);
            heights.create(bytes.length);
            int bytePos = 0;
            while (bytePos < bytes.length) {
                short val = BIT_UTIL.toShort(bytes, bytePos);
                if (val < -1000 || val > 12000) {
                    val = Short.MIN_VALUE;
                }
                heights.setShort(bytePos, val);
                bytePos += 2;
            }
            heights.setHeader(0, bytes.length / 2);
            heights.flush();
        }
        catch (FileNotFoundException ex) {
            this.logger.warn("File not found for the coordinates for " + lat + "," + lon);
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("There was an issue looking up the coordinates for " + lat + "," + lon, ex);
        }
    }

    private byte[] getByteArrayFromFile(double lat, double lon) throws InterruptedException, IOException {
        String zippedURL = String.valueOf(this.baseUrl) + this.getDownloadURL(lat, lon);
        File file = new File(this.cacheDir, new File(zippedURL).getName());
        if (!file.exists()) {
            int i = 0;
            while (i < 3) {
                try {
                    this.downloader.downloadFile(zippedURL, file.getAbsolutePath());
                    break;
                }
                catch (SocketTimeoutException ex) {
                    Thread.sleep(2000L);
                    ++i;
                }
            }
        }
        return this.readFile(file);
    }

    abstract byte[] readFile(File var1) throws IOException;
}

