/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.debatty.java.stringsimilarity;

import java.util.Arrays;

public class JaroWinkler {
    private static final double DEFAULT_THRESHOLD = 0.7;
    private static final int THREE = 3;
    private static final double JW_COEF = 0.1;
    private final double threshold;

    public JaroWinkler() {
        this.threshold = 0.7;
    }

    public JaroWinkler(double threshold) {
        this.threshold = threshold;
    }

    public final double getThreshold() {
        return this.threshold;
    }

    public final double similarity(String s1, String s2) {
        double j;
        int[] mtp = this.matches(s1, s2);
        float m = mtp[0];
        if (m == 0.0f) {
            return 0.0;
        }
        double jw = j = (double)((m / (float)s1.length() + m / (float)s2.length() + (m - (float)mtp[1]) / m) / 3.0f);
        if (j > this.getThreshold()) {
            jw = j + Math.min(0.1, 1.0 / (double)mtp[3]) * (double)mtp[2] * (1.0 - j);
        }
        return jw;
    }

    public final double distance(String s1, String s2) {
        return 1.0 - this.similarity(s1, s2);
    }

    private int[] matches(String s1, String s2) {
        String min;
        String max;
        if (s1.length() > s2.length()) {
            max = s1;
            min = s2;
        } else {
            max = s2;
            min = s1;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        int mi = 0;
        while (mi < min.length()) {
            char c1 = min.charAt(mi);
            int xi = Math.max(mi - range, 0);
            int xn = Math.min(mi + range + 1, max.length());
            while (xi < xn) {
                if (!matchFlags[xi] && c1 == max.charAt(xi)) {
                    matchIndexes[mi] = xi;
                    matchFlags[xi] = true;
                    ++matches;
                    break;
                }
                ++xi;
            }
            ++mi;
        }
        char[] ms1 = new char[matches];
        char[] ms2 = new char[matches];
        int i = 0;
        int si = 0;
        while (i < min.length()) {
            if (matchIndexes[i] != -1) {
                ms1[si] = min.charAt(i);
                ++si;
            }
            ++i;
        }
        i = 0;
        si = 0;
        while (i < max.length()) {
            if (matchFlags[i]) {
                ms2[si] = max.charAt(i);
                ++si;
            }
            ++i;
        }
        int transpositions = 0;
        int mi2 = 0;
        while (mi2 < ms1.length) {
            if (ms1[mi2] != ms2[mi2]) {
                ++transpositions;
            }
            ++mi2;
        }
        int prefix = 0;
        int mi3 = 0;
        while (mi3 < min.length()) {
            if (s1.charAt(mi3) != s2.charAt(mi3)) break;
            ++prefix;
            ++mi3;
        }
        return new int[]{matches, transpositions / 2, prefix, max.length()};
    }
}

