/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.FloatDoubleHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class FloatDoubleScatterMap
extends FloatDoubleHashMap {
    public FloatDoubleScatterMap() {
        this(4);
    }

    public FloatDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static FloatDoubleScatterMap from(float[] keys, double[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatDoubleScatterMap map = new FloatDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

